package ru.yandex.autotests.directapi.matchers.banners;

import java.util.ArrayList;
import java.util.List;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AllOf;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import static org.hamcrest.Matchers.arrayWithSize;
import static org.hamcrest.Matchers.equalTo;

/**
 * User: ginger
 * Date: 25.06.12
 */
public class BannerInfoContainAndCompareSitelinksMatcher<T> extends TypeSafeMatcher<T[]> {
    private final Matcher<T> elementMatcher;

    public BannerInfoContainAndCompareSitelinksMatcher(Matcher<T> elementMatcher) {
        this.elementMatcher = elementMatcher;
    }

    @Override
    public boolean matchesSafely(T[] array) {
        for (T item : array) {
            if (elementMatcher.matches(item)) {
                return true;
            }
        }
        return false;
    }


    @Override
    public void describeTo(Description description) {
        description.appendText(JsonUtils.toString(elementMatcher));

        elementMatcher.describeTo(description);
    }

    @Factory
    public static <T> Matcher<T[]> hasItems(T[] element) {
        List<Matcher> matchers = new ArrayList<>();

        for (T el : element) {
            matchers.add(hasItem(el));
        }
        matchers.add(arrayWithSize(element.length));
        return new AllOf(matchers);
    }

    @Factory
    public static <T> Matcher<T[]> hasItem(T element) {
        return hasItem(equalTo(element));
    }

    @Factory
    public static <T> Matcher<T[]> hasItem(Matcher<T> elementMatcher) {
        return new BannerInfoContainAndCompareSitelinksMatcher<T>(elementMatcher);
    }

}


