package ru.yandex.autotests.directapi.matchers.banners;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.BeanMap;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;

import ru.yandex.autotests.direct.utils.beans.BeanWrapper;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining;
import ru.yandex.autotests.directapi.common.api45.BannerInfo;
import ru.yandex.autotests.directapi.common.api45.BannerPhraseInfo;
import ru.yandex.autotests.directapi.model.banners.BannerInfoMap;

import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.nullValue;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 09.08.13
 * Time: 16:18
 * To change this template use File | Settings | File Templates.
 */
public class BannerMatchers {
    public static <T> BeanEquals equalOnBannerLevelFields(T banner) {
        BeanCompareStrategy strategy = new BeanCompareStrategy();
        Object contactInfo = new BeanMap(banner).get(BannerInfoMap.CONTACT_INFO);
        strategy.putFieldMatcher(BannerInfoMap.CONTACT_INFO, BeanEquals.beanEquals(contactInfo));
        Object[] sitelinks = (Object[]) new BeanMap(banner).get(BannerInfoMap.SITELINKS);
        if (sitelinks != null) {
            BeanEquals<T>[] siteLinkMatchers = new BeanEquals[sitelinks.length];
            for (int i = 0; i < sitelinks.length; i++) {
                siteLinkMatchers[i] = (BeanEquals<T>) BeanEquals.beanEquals(sitelinks[i]);
            }
            strategy.putFieldMatcher(BannerInfoMap.SITELINKS,
                    IsApiBeanCollectionContaining.hasItems((BeanEquals[]) siteLinkMatchers));
        } else {
            strategy.putFieldMatcher(BannerInfoMap.SITELINKS, nullValue());
        }
        return BeanEquals.beanEquals(banner)
                .byFields(
                        BannerInfoMap.TITLE,
                        BannerInfoMap.TEXT,
                        BannerInfoMap.HREF,
                        BannerInfoMap.AGE_LABEL,
                        BannerInfoMap.SITELINKS,
                        BannerInfoMap.CONTACT_INFO
                ).accordingStrategy(strategy);
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasBannerLevelFieldsEqualTo(BannerInfo banner) {
        List<Matcher<? super BeanWrapper<BannerInfo>>> matchers =
                new ArrayList<Matcher<? super BeanWrapper<BannerInfo>>>();
        Matcher<BeanWrapper<BannerInfo>> matcher = has(BannerInfoMap.TEXT, Matchers.equalTo(banner.getText()));
        matchers.add(matcher);
        matcher = has(BannerInfoMap.TITLE, Matchers.equalTo(banner.getTitle()));
        matchers.add(matcher);
        matcher = has(BannerInfoMap.HREF, Matchers.equalTo(banner.getHref()));
        matchers.add(matcher);
        matcher = has(BannerInfoMap.SITELINKS, Matchers.equalTo(banner.getSitelinks()));
        matchers.add(matcher);
        matcher = has(BannerInfoMap.CONTACT_INFO, Matchers.equalTo(banner.getContactInfo()));
        matchers.add(matcher);
        matcher = has(BannerInfoMap.AGE_LABEL, Matchers.equalTo(banner.getAgeLabel()));
        matchers.add(matcher);
        return new AllOf(matchers);
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasAdGroupID(final Matcher<Long> matcher) {
        return new FeatureMatcher<BeanWrapper<BannerInfo>, Long>(
                matcher, null, null)
        {
            @Override
            protected Long featureValueOf(BeanWrapper<BannerInfo> banner) {
                return banner.getBean().getAdGroupID();
            }

        };
    }

    public static <T1, T2> Matcher<BeanWrapper<T2>> has(final String fieldName, final Matcher<T1> matcher) {
        return new FeatureMatcher<BeanWrapper<T2>, T1>(
                matcher, "banner has " + fieldName + " - ", fieldName + " -")
        {
            @Override
            protected T1 featureValueOf(BeanWrapper<T2> banner) {
                return (T1) new BeanMap(banner.getBean()).get(fieldName);
            }

        };
    }

    public static <T1, T2> Matcher<BeanWrapper<T2>> contactInfoHas(final String fieldName, final Matcher<T1> matcher) {
        return new FeatureMatcher<BeanWrapper<T2>, T1>(
                matcher, "banner ContactInfo has " + fieldName + " - ", fieldName + " -")
        {
            @Override
            protected T1 featureValueOf(BeanWrapper<T2> banner) {
                return (T1) new BeanMap(new BeanMap(banner.getBean()).get(BannerInfoMap.CONTACT_INFO)).get(fieldName);
            }

        };
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasAdGroupName(final Matcher<String> matcher) {
        return has(BannerInfoMap.AD_GROUP_NAME, matcher);
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasTitle(final Matcher<String> matcher) {
        return has(BannerInfoMap.TITLE, matcher);
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasCampaignID(final Matcher<Integer> matcher) {
        return new FeatureMatcher<BeanWrapper<BannerInfo>, Integer>(
                matcher, null, null)
        {
            @Override
            protected Integer featureValueOf(BeanWrapper<BannerInfo> banner) {
                return banner.getBean().getCampaignID();
            }

        };
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasBannerID(final Matcher<Long> matcher) {
        return new FeatureMatcher<BeanWrapper<BannerInfo>, Long>(
                matcher, null, null)
        {
            @Override
            protected Long featureValueOf(BeanWrapper<BannerInfo> banner) {
                return banner.getBean().getBannerID();
            }

        };
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasDomain(final Matcher<String> matcher) {
        return has(BannerInfoMap.DOMAIN, matcher);
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasPhrases(final String... phrases) {
        return new FeatureMatcher<BeanWrapper<BannerInfo>, List<String>>(
                hasItems(phrases), "banner phrases - ", "phrases - ")
        {

            @Override
            protected List<String> featureValueOf(BeanWrapper<BannerInfo> banner) {
                BannerPhraseInfo[] phraseInfos = banner.getBean().getPhrases();
                List<String> phrases = new ArrayList<String>(phraseInfos.length);
                for (BannerPhraseInfo phraseInfo : phraseInfos) {
                    phrases.add(phraseInfo.getPhrase());
                }
                return phrases;
            }

        };
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasPhraseInfo(final BannerPhraseInfo phrase) {
        return new FeatureMatcher<BeanWrapper<BannerInfo>, List<BeanWrapper<BannerPhraseInfo>>>(
                hasItem(PhraseMatchers.ignoreForecastEqualTo(phrase)), "banner phrases - ", "phrases - ")
        {

            @Override
            protected List<BeanWrapper<BannerPhraseInfo>> featureValueOf(BeanWrapper<BannerInfo> banner) {
                BannerPhraseInfo[] phraseInfos = banner.getBean().getPhrases();
                List<BeanWrapper<BannerPhraseInfo>> result = new ArrayList<BeanWrapper<BannerPhraseInfo>>();
                for (BannerPhraseInfo phraseInfo : phraseInfos) {
                    result.add(BeanWrapper.wrap(phraseInfo));
                }
                return result;
            }

        };
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasPhraseInfo(final Matcher<BeanWrapper<BannerPhraseInfo>> match) {
        return new FeatureMatcher<BeanWrapper<BannerInfo>, List<BeanWrapper<BannerPhraseInfo>>>(
                hasItem(match), "banner phrases - ", "phrases - ")
        {

            @Override
            protected List<BeanWrapper<BannerPhraseInfo>> featureValueOf(BeanWrapper<BannerInfo> banner) {
                BannerPhraseInfo[] phraseInfos = banner.getBean().getPhrases();
                List<BeanWrapper<BannerPhraseInfo>> result = new ArrayList<BeanWrapper<BannerPhraseInfo>>();
                for (BannerPhraseInfo phraseInfo : phraseInfos) {
                    result.add(BeanWrapper.wrap(phraseInfo));
                }
                return result;
            }

        };
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasStatusBannerModerate(final Matcher<String> matcher) {
        return new FeatureMatcher<BeanWrapper<BannerInfo>, String>(
                matcher, null, null)
        {
            @Override
            protected String featureValueOf(BeanWrapper<BannerInfo> banner) {
                return banner.getBean().getStatusBannerModerate();
            }

        };
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasStatusPhrasesModerate(final Matcher<String> matcher) {
        return new FeatureMatcher<BeanWrapper<BannerInfo>, String>(
                matcher, null, null)
        {
            @Override
            protected String featureValueOf(BeanWrapper<BannerInfo> banner) {
                return banner.getBean().getStatusPhrasesModerate();
            }

        };
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasStatusSitelinksModerate(final Matcher<String> matcher) {
        return new FeatureMatcher<BeanWrapper<BannerInfo>, String>(
                matcher, null, null)
        {
            @Override
            protected String featureValueOf(BeanWrapper<BannerInfo> banner) {
                return banner.getBean().getStatusSitelinksModerate();
            }

        };
    }

    public static Matcher<BeanWrapper<BannerInfo>> hasStatusPhoneModerate(final Matcher<String> matcher) {
        return new FeatureMatcher<BeanWrapper<BannerInfo>, String>(
                matcher, null, null)
        {
            @Override
            protected String featureValueOf(BeanWrapper<BannerInfo> banner) {
                return banner.getBean().getStatusPhoneModerate();
            }

        };
    }
}
