package ru.yandex.autotests.directapi.matchers.banners;

import org.apache.commons.beanutils.BeanMap;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;

import ru.yandex.autotests.direct.utils.beans.BeanWrapper;
import ru.yandex.autotests.directapi.common.api45.BannerPhraseInfo;
import ru.yandex.autotests.directapi.model.banners.phrases.BannerPhraseInfoMap;

import static org.hamcrest.Matchers.allOf;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 09.08.13
 * Time: 16:18
 * To change this template use File | Settings | File Templates.
 */
public class PhraseMatchers {
    public static Matcher<BeanWrapper<BannerPhraseInfo>> withPhrase(final Matcher<String> matcher) {
        return has(BannerPhraseInfoMap.PHRASE, matcher);
    }

    public static Matcher<BeanWrapper<BannerPhraseInfo>> withPrice(final Matcher<Float> matcher) {
        return has(BannerPhraseInfoMap.PRICE, matcher);
    }

    public static Matcher<BeanWrapper<BannerPhraseInfo>> withContextPrice(final Matcher<Float> matcher) {
        return has(BannerPhraseInfoMap.CONTEXT_PRICE, matcher);
    }

    public static Matcher<BeanWrapper<BannerPhraseInfo>> withAutoBroker(final Matcher<String> matcher) {
        return has(BannerPhraseInfoMap.AUTO_BROKER, matcher);
    }

    public static Matcher<BeanWrapper<BannerPhraseInfo>> isRubric(final Matcher<String> matcher) {
        return has(BannerPhraseInfoMap.IS_RUBRIC, matcher);
    }

    public static <T> Matcher<BeanWrapper<BannerPhraseInfo>> has(final String field, final Matcher<T> matcher) {
        return new FeatureMatcher<BeanWrapper<BannerPhraseInfo>, T>(
                matcher, "phrase has " + field + " - ", field + " -")
        {
            @Override
            protected T featureValueOf(BeanWrapper<BannerPhraseInfo> phraseInfo) {
                return (T) new BeanMap(phraseInfo.getBean()).get(field);
            }

        };
    }


    public static Matcher<BeanWrapper<BannerPhraseInfo>> ignoreForecastEqualTo(final BannerPhraseInfo phraseInfo) {
        return allOf(
                has(BannerPhraseInfoMap.PHRASE, IsEqual.equalTo(phraseInfo.getPhrase())),
                has(BannerPhraseInfoMap.IS_RUBRIC, IsEqual.equalTo(phraseInfo.getIsRubric())),
                has(BannerPhraseInfoMap.PRICE, IsEqual.equalTo(phraseInfo.getPrice())),
                has(BannerPhraseInfoMap.CONTEXT_PRICE, IsEqual.equalTo(phraseInfo.getContextPrice())),
                has(BannerPhraseInfoMap.AUTO_BROKER, IsEqual.equalTo(phraseInfo.getAutoBroker())),
                has(BannerPhraseInfoMap.AUTO_BUDGET_PRIORITY, IsEqual.equalTo(phraseInfo.getAutoBudgetPriority())),
                has(BannerPhraseInfoMap.AD_GROUP_ID, IsEqual.equalTo(phraseInfo.getAdGroupID()))
        );
    }
}
