package ru.yandex.autotests.directapi.matchers.banners;

import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

import ru.yandex.autotests.directapi.common.api45.Retargeting;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 25.09.13
 * Time: 16:53
 * To change this template use File | Settings | File Templates.
 */
public class RetargetingMatchers {
    public static Matcher<Retargeting> hasID(final Matcher<Integer> matcher) {
        return new FeatureMatcher<Retargeting, Integer>(
                matcher, null, null)
        {
            @Override
            protected Integer featureValueOf(Retargeting retargeting) {
                return retargeting.getRetargetingID();
            }

        };
    }

    public static Matcher<? super Retargeting> hasRetargetingConditionID(final Matcher<Integer> matcher) {
        return new FeatureMatcher<Retargeting, Integer>(
                matcher, null, null)
        {
            @Override
            protected Integer featureValueOf(Retargeting retargeting) {
                return retargeting.getRetargetingConditionID();
            }

        };
    }

    public static Matcher<? super Retargeting> hasContextPrice(final Matcher<Float> matcher) {
        return new FeatureMatcher<Retargeting, Float>(
                matcher, null, null)
        {
            @Override
            protected Float featureValueOf(Retargeting retargeting) {
                return retargeting.getContextPrice();
            }

        };
    }

    public static Matcher<? super Retargeting> hasAdID(final Matcher<Long> matcher) {
        return new FeatureMatcher<Retargeting, Long>(
                matcher, null, null)
        {
            @Override
            protected Long featureValueOf(Retargeting retargeting) {
                return retargeting.getAdID();
            }

        };
    }
}
