package ru.yandex.autotests.directapi.matchers.beans;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 25.03.13
 * Time: 17:43
 * To change this template use File | Settings | File Templates.
 */
public class BeanAssert {
    private Object beanObject;

    private BeanAssert(Object bean) {
        beanObject = bean;
    }

    public static BeanAssert with(Object bean) {
        return new BeanAssert(bean);
    }

    public BeanAssert and() {
        return this;
    }

    public <T> BeanAssert assertThat(String reason, Matcher<T> matcher) {
        if (!matcher.matches(beanObject)) {
            Description description = new StringDescription();
            description.appendText(reason)
                    .appendText("\nExpected: ")
                    .appendDescriptionOf(matcher)
                    .appendText("\n     but: ")
                    .appendText(JsonUtils.toString(beanObject, true));
            throw new AssertionError(description.toString());
        }
        return this;
    }

    public <T> BeanAssert assertThat(Matcher<T> matcher) {
        if (!matcher.matches(beanObject)) {
            Description description = new StringDescription();
            description.appendText("\nExpected: ");
            description.appendDescriptionOf(matcher);
            description.appendText("\n     got: ");
            description.appendValue(JsonUtils.toString(beanObject));
            description.appendText("\n");
            throw new java.lang.AssertionError(description.toString());
        }
        return this;
    }

    public BeanAssert assertThat(String reason, boolean assertion) {
        if (!assertion) {
            throw new AssertionError(reason);
        }
        return this;
    }


}
