package ru.yandex.autotests.directapi.matchers.beans;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.ReflectionUtils;

/**
 * User: mariabye
 * Date: 25.03.13
 */
public class FieldMatcher extends BaseMatcher {
    private final String field;
    private final Matcher elementMatcher;

    public FieldMatcher(String field, Matcher elementMatcher) {
        this.field = StringUtils.capitalize(field);
        this.elementMatcher = elementMatcher;
    }

    @Override
    public boolean matches(Object o) {
        Object value = o != null ? ReflectionUtils.invokeGetter(o, field) : null;
        return elementMatcher.matches(value);
    }

    @Override
    public void describeTo(Description description) {
        description
                .appendText("has field " + field + " value ")
                .appendDescriptionOf(elementMatcher);
    }

    @Factory
    public static Matcher hasField(String field, Matcher elementMatcher) {
        return new FieldMatcher(field, elementMatcher);
    }

}
