package ru.yandex.autotests.directapi.matchers.beans.version5;

import javax.xml.bind.JAXBElement;

import org.hamcrest.Factory;

import ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;

/**
 * Created by chicos on 04.12.2014.
 */
public class BeanDifferMatcherV5 {

    @Factory
    public static <T> BeanDifferMatcher<T> beanDifferV5(T expectedBean) {
        return BeanDifferMatcher.beanDiffer(expectedBean)
                .withVariation(new DefaultMatchVariation()
                        .forClasses(JAXBElement.class)
                        .use(new JAXBElementDiffer())
                );
    }

    @Factory
    public static <T> BeanDifferMatcher<T> beanEquivalentV5(T expectedBean) {
        return BeanDifferMatcher.beanEquivalent(expectedBean)
                .withVariation(new DefaultMatchVariation()
                        .forClasses(JAXBElement.class)
                        .use(new JAXBElementDiffer())
                );
    }
}
