package ru.yandex.autotests.directapi.matchers.campaign;

import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.BeanWrapper;
import ru.yandex.autotests.directapi.common.api45.CampaignContextStrategy;
import ru.yandex.autotests.directapi.common.api45.CampaignInfo;
import ru.yandex.autotests.directapi.model.campaigns.CampaignInfoMap;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 09.08.13
 * Time: 16:18
 * To change this template use File | Settings | File Templates.
 */
public class CampaignMatchers {
    public static <T, V> Matcher<T> hasSearchStrategy(final V strategy) {
        return new FeatureMatcher<T, BeanWrapper<V>>(
                equalTo(wrap(strategy)), "campaign has strategy - ", "strategy -")
        {
            @Override
            protected BeanWrapper<V> featureValueOf(T campaign) {
                return wrap((V) new CampaignInfoMap(campaign).get(CampaignInfoMap.STRATEGY));
            }

        };
    }

    public static Matcher<CampaignInfo> hasContextStrategy(final CampaignContextStrategy strategy) {
        return new FeatureMatcher<CampaignInfo, BeanWrapper<CampaignContextStrategy>>(
                equalTo(wrap(strategy)), "campaign has context strategy - ", "context strategy -")
        {
            @Override
            protected BeanWrapper<CampaignContextStrategy> featureValueOf(CampaignInfo campaign) {
                return wrap(campaign.getContextStrategy());
            }
        };
    }
}
