package ru.yandex.autotests.directapi.matchers.campaign;

import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.directapi.model.campaigns.StrategyMap;

import static org.hamcrest.Matchers.equalTo;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 09.08.13
 * Time: 16:18
 * To change this template use File | Settings | File Templates.
 */
public class StrategyMatchers {
    public static <T> Matcher<T> hasName(final String strategyName) {
        return new FeatureMatcher<T, String>(
                equalTo(strategyName), "campaign has strategy on search with name - ", "strategyName -")
        {
            @Override
            protected String featureValueOf(T strategy) {
                return (String) ReflectionUtils.invokeGetter(strategy, StrategyMap.STRATEGY_NAME);
            }
        };
    }

    public static <T> Matcher<T> hasMaxPrice(final Float maxPrice) {
        return new FeatureMatcher<T, Float>(
                equalTo(maxPrice), "campaign has strategy on search with maxPrice - ", "maxPrice -")
        {
            @Override
            protected Float featureValueOf(T strategy) {
                return ((Float) ReflectionUtils.invokeGetter(strategy, StrategyMap.MAX_PRICE));
            }
        };
    }

    public static <T> Matcher<T> hasWeeklySumLimit(final Float weeklySumLimit) {
        return new FeatureMatcher<T, Float>(
                equalTo(weeklySumLimit), "campaign has strategy on search with weeklySumLimit - ", "weeklySumLimit -")
        {
            @Override
            protected Float featureValueOf(T strategy) {
                return (Float) ReflectionUtils.invokeGetter(strategy, StrategyMap.WEEKLY_SUM_LIMIT);
            }
        };
    }

    public static <T> Matcher<T> hasGoalID(final Long goalID) {
        return new FeatureMatcher<T, Long>(
                equalTo(goalID), "campaign has strategy on search with goalID - ", "goalID -")
        {
            @Override
            protected Long featureValueOf(T strategy) {
                return (Long) ReflectionUtils.invokeGetter(strategy, StrategyMap.GOAL_ID);
            }
        };
    }

    public static <T> Matcher<T> hasClicksPerWeek(final Integer clicksPerWeek) {
        return new FeatureMatcher<T, Integer>(
                equalTo(clicksPerWeek), "campaign has strategy on search with clicksPerWeek - ", "clicksPerWeek -")
        {
            @Override
            protected Integer featureValueOf(T strategy) {
                return (Integer) ReflectionUtils.invokeGetter(strategy, StrategyMap.CLICKS_PER_WEEK);
            }
        };
    }

    public static <T> Matcher<T> hasAveragePrice(final Float averagePrice) {
        return new FeatureMatcher<T, Float>(
                equalTo(averagePrice), "campaign has strategy on search with averagePrice - ", "averagePrice -")
        {
            @Override
            protected Float featureValueOf(T strategy) {
                return (Float) ReflectionUtils.invokeGetter(strategy, StrategyMap.AVERAGE_PRICE);
            }
        };
    }

    public static <T> Matcher<T> hasAverageCPA(final Float averageCPA) {
        return new FeatureMatcher<T, Float>(
                equalTo(averageCPA), "campaign has strategy on search with averageCPA - ", "averageCPA -")
        {
            @Override
            protected Float featureValueOf(T strategy) {
                return (Float) ReflectionUtils.invokeGetter(strategy, StrategyMap.AVERAGE_CPA);
            }
        };
    }
}
