package ru.yandex.autotests.directapi.matchers.clients;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.beans.BeanWrapper;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 21.10.13
 * Time: 11:36
 * To change this template use File | Settings | File Templates.
 */
public class ClientMatchers {
    public static <T> Matcher<T> hasLogin(final String login) {
        return new FeatureMatcher<T, String>(
                equalTo(login), "", "login ")
        {
            @Override
            protected String featureValueOf(T client) {
                try {
                    return BeanUtilsBean.getInstance().getProperty(client, "login");
                } catch (Exception e) {
                    throw new DirectAPIException("Ошибка чтения свойства", e);
                }
            }

        };
    }

    public static <T> Matcher<BeanWrapper<T>> hasClientCurrencies(final Matcher<String[]> matcher) {
        return new FeatureMatcher<BeanWrapper<T>, String[]>(
                matcher, null, null)
        {
            @Override
            protected String[] featureValueOf(BeanWrapper<T> client) {
                return (String[]) ReflectionUtils.invokeGetter(client.getBean(),
                        capitalize(ClientInfoMap.CLIENT_CURRENCIES));
            }

        };
    }

    public static <T> Matcher<BeanWrapper<T>> hasOverdraftSumAvailable(final Matcher<Float> matcher) {
        return new FeatureMatcher<BeanWrapper<T>, Float>(
                matcher, null, null)
        {
            @Override
            protected Float featureValueOf(BeanWrapper<T> client) {
                return (Float) ReflectionUtils.invokeGetter(client.getBean(),
                        capitalize(ClientInfoMap.OVERDRAFT_SUM_AVAILABLE));
            }

        };
    }
}
