package ru.yandex.autotests.directapi.matchers.comporators;

import java.util.Arrays;
import java.util.Comparator;

import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import static org.junit.Assert.fail;

/**
 * Created by IntelliJ IDEA.
 * User: mariabye
 * Date: 14.11.11
 * Time: 9:35
 * сортировщик для timeTargetItem. потребовался так как, неизвестно в каком порядке они возвращаются от сервера
 * что приводит к проблемам при сравнении
 */
public class TimeTargetItemComparator<T> implements Comparator<T> {
    private int[] getDays(T timeTargetItem) {
        try {
            return (int[]) ReflectionUtils.invokeGetter(timeTargetItem, "Days");
        } catch (DirectAPIException e) {
            fail("Ошибка теста: Не удалось получить getDays у " + JsonUtils.toString(timeTargetItem));
            return null;
        }
    }

    @Override
    public int compare(T timeTargetItem1, T timeTargetItem2) {
        Arrays.sort(getDays(timeTargetItem1));
        Arrays.sort(getDays(timeTargetItem2));

        if (getDays(timeTargetItem1).length < getDays(timeTargetItem2).length) {
            return -1;
        } else if (getDays(timeTargetItem1).length > getDays(timeTargetItem2).length) {
            return 1;
        } else {
            if (Arrays.equals(getDays(timeTargetItem1), getDays(timeTargetItem2))) {
                return 1;
            } else {
                if (getDays(timeTargetItem1)[0] == getDays(timeTargetItem2)[0]) {
                    return 1;
                } else if (getDays(timeTargetItem1)[0] < getDays(timeTargetItem2)[0]) {
                    return -1;
                } else {
                    return 1;
                }
            }
        }
    }
}
