package ru.yandex.autotests.directapi.matchers.finance;

import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.common.api45.Account;

import static org.hamcrest.Matchers.equalTo;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 17.10.13
 * Time: 12:12
 * To change this template use File | Settings | File Templates.
 */
public class AccountMatcher {
    public static Matcher<Account> hasAmount(final Matcher<Float> matcher) {
        return new FeatureMatcher<Account, Float>(
                matcher, "", "amount")
        {
            @Override
            protected Float featureValueOf(Account account) {
                return account.getAmount();
            }

        };
    }

    public static Matcher<? super Account> hasCurrency(Currency currency) {
        return new FeatureMatcher<Account, String>(
                equalTo(currency.toString()), "", "currency")
        {
            @Override
            protected String featureValueOf(Account account) {
                return account.getCurrency();
            }

        };
    }

    public static Matcher<? super Account> hasAmountAvailableForTransfer(Matcher<Float> matcher) {
        return new FeatureMatcher<Account, Float>(
                matcher, "", "amountAvailableForTransfer")
        {
            @Override
            protected Float featureValueOf(Account account) {
                return account.getAmountAvailableForTransfer();
            }

        };
    }
}
