package ru.yandex.autotests.directapi.matchers.finance;

import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.ReflectionUtils;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 09.08.13
 * Time: 16:18
 * To change this template use File | Settings | File Templates.
 */
public class BalanceMatcher {
    public static <T> Matcher<T> hasSum(Matcher<Float> matcher) {
        return new FeatureMatcher<T, Float>(
                matcher, "", "sum")
        {
            @Override
            protected Float featureValueOf(T objectWithBalance) {
                return (Float) ReflectionUtils.invokeGetter(objectWithBalance, "Sum");
            }
        };
    }

    public static <T> Matcher<T> hasRest(Matcher<Float> matcher) {
        return new FeatureMatcher<T, Float>(
                matcher, "", "rest")
        {
            @Override
            protected Float featureValueOf(T objectWithBalance) {
                return (Float) ReflectionUtils.invokeGetter(objectWithBalance, "Rest");
            }
        };
    }

    public static <T> Matcher<T> hasSumAvailableForTransfer(Matcher<Float> matcher) {
        return new FeatureMatcher<T, Float>(
                matcher, "", "SumAvailableForTransfer")
        {
            @Override
            protected Float featureValueOf(T objectWithBalance) {
                return (Float) ReflectionUtils.invokeGetter(objectWithBalance, "SumAvailableForTransfer");
            }
        };
    }
}
