package ru.yandex.autotests.directapi.matchers.getchanges;

import java.util.Arrays;

import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by pavryabov on 12.04.16.
 */
public class GetChangesIntDataMatcher<T> extends TypeSafeDiagnosingMatcher<T> {
    private int[] updatedIDS;
    private int[] notUpdatedIDS;
    private int[] notFoundIDS;
    private T result;

    public GetChangesIntDataMatcher(int[] updatedIDS, int[] notUpdatedIDS, int[] notFoundIDS) {
        this.updatedIDS = updatedIDS;
        this.notUpdatedIDS = notUpdatedIDS;
        this.notFoundIDS = notFoundIDS;
    }

    @Override
    protected boolean matchesSafely(T item, Description mismatchDescription) {
        this.result = item;
        BeanToPropertyValueTransformer transformerForUpdated = new BeanToPropertyValueTransformer("updated");
        int[] gotUpdatedIDS = (int[]) transformerForUpdated.transform(this.result);
        BeanToPropertyValueTransformer transformerForNotUpdated = new BeanToPropertyValueTransformer("notUpdated");
        int[] gotNotUpdatedIDS = (int[]) transformerForNotUpdated.transform(this.result);
        BeanToPropertyValueTransformer transformerForNotFound = new BeanToPropertyValueTransformer("notFound");
        int[] gotNotFoundIDS = (int[]) transformerForNotFound.transform(this.result);

        boolean matchesResult = (Arrays.equals(gotUpdatedIDS, updatedIDS) &&
                Arrays.equals(gotNotUpdatedIDS, notUpdatedIDS) &&
                Arrays.equals(gotNotFoundIDS, notFoundIDS));

        if (!matchesResult) {
            mismatchDescription.appendText("has response with ");
            mismatchDescription.appendText("\nUpdated: " + JsonUtils.toString(gotUpdatedIDS));
            mismatchDescription.appendText("\nNotUpdated: " + JsonUtils.toString(gotNotUpdatedIDS));
            mismatchDescription.appendText("\nNotFound: " + JsonUtils.toString(gotNotFoundIDS));
        }
        return matchesResult;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Updated: " + JsonUtils.toString(updatedIDS));
        description.appendText("\nNotUpdated: " + JsonUtils.toString(notUpdatedIDS));
        description.appendText("\nNotFound: " + JsonUtils.toString(notFoundIDS));
    }

    @Factory
    public static <T> Matcher<T> updatedContains(int[] ids) {
        return new GetChangesIntDataMatcher(ids, new int[0], new int[0]);
    }

    @Factory
    public static <T> Matcher<T> notUpdatedContains(int[] ids) {
        return new GetChangesIntDataMatcher(new int[0], ids, new int[0]);
    }

    @Factory
    public static <T> Matcher<T> notFoundContains(int[] ids) {
        return new GetChangesIntDataMatcher(new int[0], new int[0], ids);
    }

    @Factory
    public static <T> Matcher<T> updatedAndNotUpdatedContains(int[] updatedIDS, int[] notUpdatedIDS) {
        return new GetChangesIntDataMatcher(updatedIDS, notUpdatedIDS, new int[0]);
    }

    @Factory
    public static <T> Matcher<T> responseContains(int[] updatedIDS, int[] notUpdatedIDS, int[] notFoundIDS) {
        return new GetChangesIntDataMatcher(updatedIDS, notUpdatedIDS, notFoundIDS);
    }
}
