package ru.yandex.autotests.directapi.matchers.getchanges;

import java.util.Arrays;

import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created with longelliJ IDEA.
 * User: pavryabov
 * Date: 23.09.13
 * Time: 16:49
 * To change this template use File | Settings | File Templates.
 */
public class GetChangesLongDataMatcher<T> extends TypeSafeDiagnosingMatcher<T> {
    private long[] updatedIDS;
    private long[] notUpdatedIDS;
    private long[] notFoundIDS;
    private T result;

    public GetChangesLongDataMatcher(long[] updatedIDS, long[] notUpdatedIDS, long[] notFoundIDS) {
        this.updatedIDS = updatedIDS;
        this.notUpdatedIDS = notUpdatedIDS;
        this.notFoundIDS = notFoundIDS;
    }

    @Override
    protected boolean matchesSafely(T item, Description mismatchDescription) {
        this.result = item;
        BeanToPropertyValueTransformer transformerForUpdated = new BeanToPropertyValueTransformer("updated");
        long[] gotUpdatedIDS = (long[]) transformerForUpdated.transform(this.result);
        BeanToPropertyValueTransformer transformerForNotUpdated = new BeanToPropertyValueTransformer("notUpdated");
        long[] gotNotUpdatedIDS = (long[]) transformerForNotUpdated.transform(this.result);
        BeanToPropertyValueTransformer transformerForNotFound = new BeanToPropertyValueTransformer("notFound");
        long[] gotNotFoundIDS = (long[]) transformerForNotFound.transform(this.result);

        boolean matchesResult = (Arrays.equals(gotUpdatedIDS, updatedIDS) &&
                Arrays.equals(gotNotUpdatedIDS, notUpdatedIDS) &&
                Arrays.equals(gotNotFoundIDS, notFoundIDS));

        if (!matchesResult) {
            mismatchDescription.appendText("has response with ");
            mismatchDescription.appendText("\nUpdated: " + JsonUtils.toString(gotUpdatedIDS));
            mismatchDescription.appendText("\nNotUpdated: " + JsonUtils.toString(gotNotUpdatedIDS));
            mismatchDescription.appendText("\nNotFound: " + JsonUtils.toString(gotNotFoundIDS));
        }
        return matchesResult;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Updated: " + JsonUtils.toString(updatedIDS));
        description.appendText("\nNotUpdated: " + JsonUtils.toString(notUpdatedIDS));
        description.appendText("\nNotFound: " + JsonUtils.toString(notFoundIDS));
    }

    @Factory
    public static <T> Matcher<T> updatedContains(long[] ids) {
        return new GetChangesLongDataMatcher(ids, new long[0], new long[0]);
    }

    @Factory
    public static <T> Matcher<T> notUpdatedContains(long[] ids) {
        return new GetChangesLongDataMatcher(new long[0], ids, new long[0]);
    }

    @Factory
    public static <T> Matcher<T> notFoundContains(long[] ids) {
        return new GetChangesLongDataMatcher(new long[0], new long[0], ids);
    }

    @Factory
    public static <T> Matcher<T> updatedAndNotUpdatedContains(long[] updatedIDS, long[] notUpdatedIDS) {
        return new GetChangesLongDataMatcher(updatedIDS, notUpdatedIDS, new long[0]);
    }

    @Factory
    public static <T> Matcher<T> responseContains(long[] updatedIDS, long[] notUpdatedIDS, long[] notFoundIDS) {
        return new GetChangesLongDataMatcher(updatedIDS, notUpdatedIDS, notFoundIDS);
    }
}
