package ru.yandex.autotests.directapi.matchers.subscription;

import java.util.Arrays;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import static ru.yandex.autotests.directapi.model.subscription.SubscriptionMap.EVENT_TYPES;

/**
 * User: mariabye
 * Date: 14.11.11
 */
public class SubscriptionMatcher<T> extends BaseMatcher<T> {
    private Object expected;

    public SubscriptionMatcher(T expected) {
        this.expected = expected;
    }


    @Override
    public boolean matches(Object got) {
        if (expected == null && got == null) {
            return true;
        } else {
            if (expected != null && got != null) {
                Object eventTypes1 = null;
                Object eventTypes2 = null;
                try {
                    eventTypes1 = ReflectionUtils.invokeGetter(expected, EVENT_TYPES);
                    eventTypes2 = ReflectionUtils.invokeGetter(got, EVENT_TYPES);
                } catch (Exception e) {
                    return false;
                }
                if (eventTypes1 != null && eventTypes2 != null) {
                    Arrays.sort((String[]) eventTypes1);
                    Arrays.sort((String[]) eventTypes2);
                    try {
                        ReflectionUtils.invokeSetter(expected, EVENT_TYPES, eventTypes1);
                        ReflectionUtils.invokeSetter(got, EVENT_TYPES, eventTypes2);
                    } catch (DirectAPIException e) {
                        return false;
                    }
                }
                return expected.equals(got);
            } else {
                return false;
            }
        }
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(JsonUtils.toString(this.expected, true));
    }

    @Factory
    public static <T> Matcher<T> equalTo(T expected) {
        return new SubscriptionMatcher<T>(expected);
    }


}
