package ru.yandex.autotests.directapi.model;

import java.util.List;

import javax.util.streamex.StreamEx;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import static java.util.Collections.emptyList;

public class AdfoxDealPlacement {

    @JsonProperty("impId")
    private List<Long> impId;

    @JsonProperty("domain")
    private String domain;

    @JsonProperty("pageId")
    private Long pageId;

    @JsonProperty("formats")
    private List<String> formats;

    public AdfoxDealPlacement(Long pageId) {
        this.pageId = pageId;
        this.domain = "domain";
        this.impId = emptyList();
        this.formats = emptyList();
    }

    public static String getPlacementJsonsFromPageIds(List<Long> pageIds) {
        List<AdfoxDealPlacement> objectsList = StreamEx.of(pageIds)
                .map(t -> new AdfoxDealPlacement(t))
                .toList();
        try {
            return createObjectMapper().writeValueAsString(objectsList);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("can not serialize object to json", e);
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.AUTO_DETECT_CREATORS,
                MapperFeature.AUTO_DETECT_FIELDS,
                MapperFeature.AUTO_DETECT_GETTERS,
                MapperFeature.AUTO_DETECT_IS_GETTERS);
        return mapper;
    }
}
