package ru.yandex.autotests.directapi.model;


import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 13.06.13
 * Time: 1:30
 * To change this template use File | Settings | File Templates.
 */
public class ErrorMap<T> extends ModelBeanMap<ErrorMap> {
    //region Fields
    private static final String ERROR = "Error";

    public static final String FAULT_CODE = "faultCode";
    public static final String FAULT_STRING = "faultString";
    public static final String FAULT_DETAIL = "faultDetail";
    //endregion

    public ErrorMap(String packageName) {
        super(packageName, ERROR);
    }

    public ErrorMap(T error) {
        super();
        setBean(error);
    }

    public ErrorMap withAxisError(AxisError error) {
        put(FAULT_CODE, error.getErrorCode());
        put(FAULT_STRING, error.getMessage());
        put(FAULT_DETAIL, error.getDetails());
        return this;
    }

    public ErrorMap withFaultCode(String faultCode) {
        put(FAULT_CODE, faultCode);
        return this;
    }

    public ErrorMap withFaultString(String faultString) {
        put(FAULT_STRING, faultString);
        return this;
    }

    public ErrorMap withFaultDetail(String faultDetail) {
        put(FAULT_DETAIL, faultDetail);
        return this;
    }
    //region Builder

    //endregion

}
