package ru.yandex.autotests.directapi.model;

/**
 * Created by ginger on 21.05.16.
 */
public class Image {
    private final String name;
    private final String url;
    private final String dimensions;

    public Image(String name, String url, String dimensions) {
        this.name = name;
        this.url = url;
        this.dimensions = dimensions;
    }

    public Image(String name, String url) {
        this(name, url, null);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDimensions() {
        if (dimensions == null) {
            throw new IllegalStateException("У этого изображения размеры неизвестны");
        }

        return dimensions;
    }


}
