package ru.yandex.autotests.directapi.model;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.autotests.irt.testutils.RandomUtils;

/**
 * Инструкция по заливке картинок в MDS-S3:
 * https://wiki.yandex-team.ru/direct/development/howto/test-data-in-mds-s3/#poshagovajainstrukcijapopoluchenijudostupaizalivkefajjlavxranilishhe
 */
public class InvalidImageData {

    public static Map<Integer, Image> small = new HashMap<Integer, Image>() {{
        put(1, new Image("jpg 149x150",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/old/invalidimg1.gif"));
        put(2, new Image("jpg 150x149",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/old/invalidimg2.jpg"));
        put(3, new Image("jpg 149x149",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/old/invalidimg3.jpg"));
        put(4, new Image("jpg 150x201",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/old/invalidimg4.jpg"));
        put(5, new Image("jpg 201x150",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/old/invalidimg5.jpg"));
        put(6, new Image("bmp 150x150",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/small150x150.bmp"));
        put(7, new Image("jpg 200x150",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/small200x150.jpg"));
        put(8, new Image("gif 180x150",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/small180x150.gif"));
        put(9, new Image("png 150x150",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/small150x150.png"));
        put(10, new Image("jpg 150x150",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/small150x150.jpg"));
        put(11, new Image("jpg 150x200",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/small150x200.jpg"));
    }};

    //BigImage
    public static Map<Integer, Image> big = new HashMap<Integer, Image>() {{
        put(1, new Image("jpg 1079X607",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/undefined_1079x607.jpg"));
        put(2, new Image("png 2814X5001",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/2814x5001.png"));
        put(3, new Image("jpg 5001X2814",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/5001x2814.jpg"));
        put(4, new Image("jpg 5001X5001",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/undefined_5001x5001.jpg"));
        put(5, new Image("jpg 6000X6000",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/undefined_6000x6000.jpg"));
        put(6, new Image("bmp 500X500",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/regular_bmp.bmp"));
        put(7, new Image("jpg more10mb",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/more10mb.gif"));
        put(8, new Image("png 960x640 more10mb",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/960x640-big.png"));
        put(9, new Image("png 960x640 more120kb",
                "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/960x640.png",
                "960x640"));
    }};

    public static Image getInvalidBigImage() {
        return getInvalidBigImage(RandomUtils.getRandomInteger(1, big.size()));
    }

    public static Image getInvalidBigImage(int imageNumber) {
        return big.get(imageNumber);
    }

    public static Image getInvalidSmallImage() {
        return getInvalidSmallImage(RandomUtils.getRandomInteger(1, small.size()));
    }

    public static Image getInvalidSmallImage(int imageNumber) {
        return small.get(imageNumber);
    }
}
