package ru.yandex.autotests.directapi.model;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ClientPixelProvidersProvider;

public enum PixelProvider {
    ADFOX,
    ADFOX_ADMETRICA,
    MC_ADMETRICA,
    TNS,
    ADRIVER,
    YANDEXAUDIENCE,
    SIZMEK,
    GEMIUS,
    WEBORAMA,
    DCM,
    TWO_PIXEL_ONE_STRING,
    CHESTNY_AUDIT;

    private static final Map<PixelProvider, String> EXAMPLE_URLS =
            ImmutableMap.<PixelProvider, String>builder()
                    .put(ADFOX,
                            "https://ads.adfox.ru/254364/getCode?p1=bxoar&p2=v&pfc=bnkqk&pfb=failv&pr=%25aw_RANDOM%25&ptrc=%25aw_random%25")
                    .put(ADFOX_ADMETRICA,
                            "https://amc.yandex.ru/show?cmn_id=4&plt_id=4&crv_id=4&evt_tp=impression&ad_type=banner&vv_crit=mrc&rnd=%Random%")
                    .put(MC_ADMETRICA,
                            "https://mc.admetrica.ru/show?cmn_id=4&plt_id=4&crv_id=4&evt_tp=impression&ad_type=banner&vv_crit=mrc&rnd=%Random%")
                    .put(YANDEXAUDIENCE,
                            "https://mc.yandex.ru/pixel/7429537502459335683?rnd=%25aw_random%25")
                    .put(ADRIVER,
                            "https://ad.adriver.ru/cgi-bin/erle.cgi?sid=1&ad=605736&bt=43&bn=605736&rnd=%aw_random%")
                    .put(CHESTNY_AUDIT, "https://holodilnikslonokno.ru")
                    .put(TWO_PIXEL_ONE_STRING,
                            "https://ad.doubleclick.net/ddm/trackimp/N**.**YANDEX.DISPLAY/B***;dc_trk_aid=****;dc_trk_cid=***;ord=%aw_random%;dc_lat=;"
                                    + "dc_rdid=;tag_for_child_directed_treatment=;tfua=?\n" +
                                    "https://www.tns-counter.ru/V13a****zenith_ad/ru/UTF-8/tmsec=4233531_22202744-238254270/%aw_random%")
                    .put(TNS, "https://www.tns-counter.ru/V13a****bbdo_ad/ru/UTF-8/tmsec=bbdo_cid1021927-posid1323236/%25aw_random%25")
                    .put(DCM, "https://ad.doubleclick.net/ddm/trackimp/N8897.279382DBMLOREALRU166997727/B20560465.211057742;dc_trk_aid=410668675;dc_trk_cid=96238742;ord=%aw_random%;dc_lat=;dc_rdid=;tag_for_child_directed_treatment=")
                    .put(WEBORAMA, "https://wcm.solution.weborama.fr/fcgi-bin/dispatch.fcgi?a.A=im&a.si=4710&a.te=677&a.he=1&a.wi=1&a.hr=p&a.ra=%aw_random%")
                    .build();

    private static final Map<PixelProvider, ClientPixelProvidersProvider> TO_DB_ENUM =
            ImmutableMap.<PixelProvider, ClientPixelProvidersProvider>builder()
                    .put(YANDEXAUDIENCE, ClientPixelProvidersProvider.yndx_audience)
                    .put(ADRIVER, ClientPixelProvidersProvider.adriver)
                    .put(TNS, ClientPixelProvidersProvider.tns)
                    .put(SIZMEK, ClientPixelProvidersProvider.sizmek)
                    .put(GEMIUS, ClientPixelProvidersProvider.gemius)
                    .put(WEBORAMA, ClientPixelProvidersProvider.weborama)
                    .put(DCM, ClientPixelProvidersProvider.dcm)
                    .build();

    private static final Map<PixelProvider, String> PROVIDER_NAMES =
            ImmutableMap.<PixelProvider, String>builder()
                    .put(ADFOX, "Adfox")
                    .put(ADFOX_ADMETRICA, "Adfox")
                    .put(MC_ADMETRICA, "Adfox")
                    .put(YANDEXAUDIENCE, "Yandex.Audience")
                    .put(ADRIVER, "Adriver")
                    .build();

    public ClientPixelProvidersProvider pixelProviderFromDb() {
        return TO_DB_ENUM.get(this);
    }

    public String testUrl() {
        return EXAMPLE_URLS.get(this);
    }

    public String providerName() {
        return PROVIDER_NAMES.get(this);
    }
}
