package ru.yandex.autotests.directapi.model.api5;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getKey;

/**
 * Created by pavryabov on 17.06.15.
 */
public enum StatusClarification implements ITextResource {

    ACCEPTED,
    ACCEPTED_BY_MODERATOR,
    ACTIVATING,
    ARCHIVED,
    AWAITING_ARCHIVING,
    AWAITING_MODERATION,
    AWAITING_MODERATION_WITHOUT_DOT,
    CALLOUT_DOESNT_ADHERE_TO_ADV_POLICY,
    CALLOUT_DOESNT_ADHERE_TO_ADV_POLICY_JAVA,
    CAMPAIGN_ARCHIVED,
    CAMPAIGN_ENDED,
    CAMPAIGN_STOPPED,
    CAMPAIGN_STOPPED_WITH_DOT,
    CAMPAIGN_WAITING_EXTRACTED_FROM_ARCHIVE,
    CONTACT_INFO_ACCEPTED,
    CONTACT_INFO_AWAITING_MODERATION,
    CONTACT_INFO_REJECTED,
    CONVERTED,
    DISPLAY_URL_PATH_ACCEPTED,
    DISPLAY_URL_PATH_AWAITING_MODERATION,
    DISPLAY_URL_PATH_REJECTED,
    DRAFT,
    DRAFT_WITH_END_DATE,
    DRAFT_WITHOUT_DOT,
    FINISHED,
    FUNDS_HAVE_RUN_OUT,
    FUNDS_IN_ACCOUNT_ENDED,
    IMAGE_ACCEPTED,
    IMAGE_AWAITING_MODERATION,
    IMAGE_REJECTED,
    IMPRESSIONS_STOPPED_AFTER_DAY_BUDGET_SPENT,
    IMPRESSIONS_STOPPED_AFTER_DAY_BUDGET_SPENT_AT,
    NO_ACTIVE_ADS,
    NO_ADS,
    OFF_BY_MONITORING,
    ON,
    PREVIOUS_VERSION_IS_RUNNING,
    PREVIOUSLY_ACCEPTED,
    REJECTED,
    REJECTED_BY_MODERATOR,
    SITELINKS_ACCEPTED,
    SITELINKS_AWAITING_MODERATION,
    SITELINKS_REJECTED,
    START,
    SUSPENDED,
    WAIT_UNARCHIVING,
    WAITING_FOR_PAYMENT,
    WEBPAGE_ACTIVATING,
    WEBPAGE_DELETED,
    WEBPAGE_RESUMED,
    WEBPAGE_SUSPENDED;

    private static String BUNDLE = "api.StatusClarification";

    @Override
    public String getBundle() {
        return BUNDLE;
    }

    @Override
    public String toString() {
        return getKey(this);
    }

    public String getStatusClarification() {
        TextResourceFormatter resourceFormatter = TextResourceFormatter.resource(this)
                .locale(DirectTestRunProperties.getInstance().getDirectAPILocale());
        return resourceFormatter.toString();
    }

}
