package ru.yandex.autotests.directapi.model.api5.adextensions;

import com.yandex.direct.api.v5.adextensions.AdExtensionAddItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;

/**
 * Created by proxeter on 18.02.16.
 */
public class AdExtensionAddItemMap extends ModelBeanMap<AdExtensionAddItemMap> {

    public static final String CALLOUT = "callout";

    public static final Integer MAX_CALLOUT_TEXT_SIZE = 25;

    public AdExtensionAddItemMap() {
        super();
        setBean(new AdExtensionAddItem());
    }

    public AdExtensionAddItemMap(AdExtensionAddItem adExtensionAddItem) {
        super();
        setBean(adExtensionAddItem);
    }

    public AdExtensionAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdExtensionAddItemMap withCallout(CalloutMap callout) {
        this.put(CALLOUT, (callout == null) ? null : callout.getBean());
        return this;
    }

}
