package ru.yandex.autotests.directapi.model.api5.adextensions;

import com.yandex.direct.api.v5.adextensions.AdExtensionGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionBaseMap;

/**
 * Created by proxeter on 23.03.16.
 */
public class AdExtensionGetItemMap extends AdExtensionBaseMap<AdExtensionGetItemMap> {

    private static final String ID = "id";
    private static final String ASSOCIATED = "associated";

    public AdExtensionGetItemMap() {
        super();
        setBean(new AdExtensionGetItem());
    }

    public AdExtensionGetItemMap(AdExtensionGetItem adExtensionGetItem) {
        super();
        setBean(adExtensionGetItem);
    }

    public AdExtensionGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdExtensionGetItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public AdExtensionGetItemMap withAssociated(YesNoEnum associated) {
        this.put(ASSOCIATED, associated);
        return this;
    }
}
