package ru.yandex.autotests.directapi.model.api5.adextensions;

import java.util.Arrays;

import com.yandex.direct.api.v5.adextensions.AdExtensionsSelectionCriteria;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionStateSelectionEnum;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by proxeter on 19.02.16.
 */
public class AdExtensionsSelectionCriteriaMap extends ModelBeanMap<AdExtensionsSelectionCriteriaMap> {

    public static final String IDS = "ids";
    public static final String TYPES = "types";
    public static final String STATUSES = "statuses";
    public static final String STATES = "states";
    public static final String MODIFIED_SINCE = "modifiedSince";

    public static final Integer IDS_MAXIMUM = 10000;

    public AdExtensionsSelectionCriteriaMap() {
        super();
        setBean(new AdExtensionsSelectionCriteria());
    }

    public AdExtensionsSelectionCriteriaMap(AdExtensionsSelectionCriteria selectionCriteria) {
        super();
        setBean(selectionCriteria);
    }

    public AdExtensionsSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdExtensionsSelectionCriteriaMap withIds(Long... ids) {
        this.put(IDS, Arrays.asList(ids));
        return this;
    }

    public AdExtensionsSelectionCriteriaMap withTypes(AdExtensionTypeEnum... types) {
        this.put(TYPES, Arrays.asList(types));
        return this;
    }

    public AdExtensionsSelectionCriteriaMap withTypes(String... types) {
        this.put(TYPES, Arrays.asList(types));
        return this;
    }

    public AdExtensionsSelectionCriteriaMap withStatuses(ExtensionStatusSelectionEnum... statuses) {
        this.put(STATUSES, Arrays.asList(statuses));
        return this;
    }

    public AdExtensionsSelectionCriteriaMap withStatuses(String... statuses) {
        this.put(STATUSES, Arrays.asList(statuses));
        return this;
    }

    public AdExtensionsSelectionCriteriaMap withStates(AdExtensionStateSelectionEnum... states) {
        this.put(STATES, Arrays.asList(states));
        return this;
    }

    public AdExtensionsSelectionCriteriaMap withModifiedSince(String modifiedSince) {
        this.put(MODIFIED_SINCE, modifiedSince);
        return this;
    }
}
