package ru.yandex.autotests.directapi.model.api5.adextensions;

import com.yandex.direct.api.v5.adextensions.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by proxeter on 18.02.16.
 */
public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final Integer ADD_UNITS_COST = 5;
    public static final Integer ADD_OBJECT_COST = 1;
    public static final Integer ADD_INVALID_COST = 20;

    public static final Integer ADD_INVALID_WSDL_COST = 50;

    public static final String AD_EXTENSIONS = "adExtensions";

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withAdExtensions(AdExtensionAddItemMap... adExtensions) {
        this.put(AD_EXTENSIONS, (adExtensions == null) ? null : convert(adExtensions, new BeanMapToBeanConverter()));
        return this;
    }

}
