package ru.yandex.autotests.directapi.model.api5.adextensions;

import java.util.Arrays;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.CalloutFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetRequest;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

/**
 * Created by proxeter on 19.02.16.
 */
public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final Integer GET_UNITS_COST = 5;
    public static final Integer GET_OBJECT_COST = 1;
    public static final Integer GET_INVALID_COST = 20;
    public static final Integer GET_INVALID_WSDL_COST = 50;

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";
    public static final String CALLOUT_FIELD_NAMES = "calloutFieldNames";

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(AdExtensionsSelectionCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(AdExtensionFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withFieldNames(String... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withCalloutFieldNames(CalloutFieldEnum... fieldNames) {
        this.put(CALLOUT_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withCalloutFieldNames(String... fieldNames) {
        this.put(CALLOUT_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

}
