package ru.yandex.autotests.directapi.model.api5.adextensiontypes;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.adextensiontypes.Callout;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 02.03.16.
 */
public class AdExtensionBaseMap<T> extends ModelBeanMap<AdExtensionBaseMap> {

    public static final String TYPE = "type";
    public static final String CALLOUT = "callout";
    public static final String STATUS = "status";
    public static final String STATE = "state";
    public static final String STATUS_CLARIFICATION = "statusClarification";

    public AdExtensionBaseMap() {
        super();
    }

    public T withType(AdExtensionTypeEnum type) {
        this.put(TYPE, type);
        return (T) this;
    }

    public T withCallout(CalloutMap callout) {
        this.put(CALLOUT, (callout == null) ? null : (Callout) (callout.getBean()));
        return (T) this;
    }

    public T withStatus(StatusEnum status) {
        this.put(STATUS, status);
        return (T) this;
    }

    public T withState(StateEnum state) {
        this.put(STATE, state);
        return (T) this;
    }

    public T withStatusClarification(String statusClarification) {
        this.put(STATUS_CLARIFICATION, statusClarification);
        return (T) this;
    }
}
