package ru.yandex.autotests.directapi.model.api5.adextensiontypes;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionSettingItem;
import com.yandex.direct.api.v5.general.OperationEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 02.03.16.
 */
public class AdExtensionSettingItemMap extends ModelBeanMap<AdExtensionSettingItemMap> {

    public static final String AD_EXTENSION_ID = "adExtensionId";
    public static final String OPERATION = "operation";

    public AdExtensionSettingItemMap() {
        super();
        setBean(new AdExtensionSettingItem());
    }

    public AdExtensionSettingItemMap(AdExtensionSettingItem adExtensionSettingItem) {
        super();
        setBean(adExtensionSettingItem);
    }

    public AdExtensionSettingItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdExtensionSettingItemMap withAdExtensionId(Long id) {
        this.put(AD_EXTENSION_ID, id);
        return this;
    }

    public AdExtensionSettingItemMap withOperation(OperationEnum operation) {
        this.put(OPERATION, operation);
        return this;
    }
}
