package ru.yandex.autotests.directapi.model.api5.adextensiontypes;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionSetting;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 02.03.16.
 */
public class AdExtensionSettingMap extends ModelBeanMap<AdExtensionSettingMap> {

    public static final String AD_EXTENSIONS = "adExtensions";

    public AdExtensionSettingMap() {
        super();
        setBean(new AdExtensionSetting());
    }

    public AdExtensionSettingMap(AdExtensionSetting adExtensionSetting) {
        super();
        setBean(adExtensionSetting);
    }

    public AdExtensionSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdExtensionSettingMap withAdExtensions(AdExtensionSettingItemMap... maps) {
        this.put(AD_EXTENSIONS, (maps == null) ? null : convert(maps, new BeanMapToBeanConverter()));
        return this;
    }
}
