package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.adgroups.AdGroupAddItem;
import com.yandex.direct.api.v5.adgroups.CpmBannerKeywordsAdGroupAdd;
import com.yandex.direct.api.v5.adgroups.CpmBannerUserProfileAdGroupAdd;
import com.yandex.direct.api.v5.adgroups.CpmVideoAdGroupAdd;
import com.yandex.direct.api.v5.adgroups.TextAdGroupFeedParamsAdd;
import com.yandex.direct.api.v5.general.ArrayOfLong;
import com.yandex.direct.api.v5.general.ArrayOfString;
import org.apache.commons.lang3.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class AdGroupAddItemMap extends ModelBeanMap<AdGroupAddItemMap> {

    @SuppressWarnings("WeakerAccess")
    public static final String NAME = "name";
    @SuppressWarnings("WeakerAccess")
    public static final String CAMPAIGN_ID = "campaignId";
    @SuppressWarnings("WeakerAccess")
    public static final String REGION_IDS = "regionIds";
    @SuppressWarnings("WeakerAccess")
    public static final String NEGATIVE_KEYWORDS = "negativeKeywords";
    @SuppressWarnings("WeakerAccess")
    public static final String TRACKING_PARAMS = "trackingParams";
    @SuppressWarnings("WeakerAccess")
    public static final String MOBILE_APP_AD_GROUP = "mobileAppAdGroup";
    @SuppressWarnings("WeakerAccess")
    public static final String DYNAMIC_TEXT_AD_GROUP = "dynamicTextAdGroup";
    @SuppressWarnings("WeakerAccess")
    public static final String CPM_BANNER_KEYWORDS_AD_GROUP = "cpmBannerKeywordsAdGroup";
    @SuppressWarnings("WeakerAccess")
    public static final String CPM_BANNER_USER_PROFILE_AD_GROUP = "cpmBannerUserProfileAdGroup";
    @SuppressWarnings("WeakerAccess")
    public static final String TEXT_AD_GROUP_WITH_FEED_PARAMS = "textAdGroupFeedParams";

    @SuppressWarnings("WeakerAccess")
    public static final String CPM_VIDEO_AD_GROUP = "cpmVideoAdGroup";

    @SuppressWarnings("WeakerAccess")
    public static final String DEFAULT_TRACKING_PARAMS = "direct";
    @SuppressWarnings("WeakerAccess")
    public static final String DEFAULT_NAME = "newGroup";
    @SuppressWarnings("WeakerAccess")
    public static final String DEFAULT_NEGATIVE_KEYWORD = "подарки";
    @SuppressWarnings("WeakerAccess")
    public static final Long DEFAULT_REGION_ID = 0L;
    @SuppressWarnings("WeakerAccess")
    public static final int MAX_NAME_LENGTH = 255;
    @SuppressWarnings("WeakerAccess")
    public static final int MAX_WORDS_IN_NEGATIVE_KEYPHRASE = 7;
    @SuppressWarnings("WeakerAccess")
    public static final int MAX_NEGATIVE_KEYWORDS_LENGTH = 4096;


    @SuppressWarnings("WeakerAccess")
    public static final int GROUPS_MAX_LENGTH = 1000;

    public AdGroupAddItemMap() {
        super();
        setBean(new AdGroupAddItem());
    }

    public AdGroupAddItemMap(AdGroupAddItem adGroupAddItem) {
        super();
        setBean(adGroupAddItem);
    }

    @Override
    public AdGroupAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdGroupAddItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public AdGroupAddItemMap withTrackingParams(String trackingParams) {
        this.put(TRACKING_PARAMS, trackingParams);
        return this;
    }

    public AdGroupAddItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public AdGroupAddItemMap withRegionIds(Long... regionIds) {
        this.put(REGION_IDS, Arrays.asList(regionIds));
        return this;
    }

    public AdGroupAddItemMap withRegionIds(List<Long> regionIds) {
        this.put(REGION_IDS, regionIds);
        return this;
    }

    public AdGroupAddItemMap withNegativeKeywords(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString negativeKeywords =
                ((arrayOfStringMap == null) ? null : (ArrayOfString) (arrayOfStringMap.getBean()));
        this.put(NEGATIVE_KEYWORDS, negativeKeywords);
        return this;
    }

    public AdGroupAddItemMap withMobileAppAdGroup(MobileAppAdGroupAddMap mobileAppAdGroupAdd) {
        this.put(MOBILE_APP_AD_GROUP, (mobileAppAdGroupAdd == null) ? null : mobileAppAdGroupAdd.getBean());
        return this;
    }

    public AdGroupAddItemMap withDynamicTextAdGroup(DynamicTextAdGroupMap dynamicTextAdGroupAdd) {
        this.put(DYNAMIC_TEXT_AD_GROUP, (dynamicTextAdGroupAdd == null) ? null : dynamicTextAdGroupAdd.getBean());
        return this;
    }

    public AdGroupAddItemMap withCpmBannerUserProfileAdGroup() {
        this.put(CPM_BANNER_USER_PROFILE_AD_GROUP, new CpmBannerUserProfileAdGroupAdd());
        return this;
    }

    public AdGroupAddItemMap withCpmBannerKeywordsAdGroup() {
        this.put(CPM_BANNER_KEYWORDS_AD_GROUP, new CpmBannerKeywordsAdGroupAdd());
        return this;
    }

    public AdGroupAddItemMap withCpmVdeoAdGroup() {
        this.put(CPM_VIDEO_AD_GROUP, new CpmVideoAdGroupAdd());
        return this;
    }

    public AdGroupAddItemMap withDefaultGroup(AdGroupType type) {
        if (type == AdGroupType.MOBILE_CONTENT) {
            this.put(MOBILE_APP_AD_GROUP, new MobileAppAdGroupAddMap().defaultGroup().getBean());

        } else if (type == AdGroupType.DYNAMIC) {
            this.put(DYNAMIC_TEXT_AD_GROUP, new DynamicTextAdGroupMap().defaultGroup().getBean());

        } else if (type == AdGroupType.CPM_BANNER) {
            this.put(CPM_BANNER_USER_PROFILE_AD_GROUP, new CpmBannerUserProfileAdGroupAdd());

        }
        return this;
    }

    public AdGroupAddItemMap withTextAdGroupFeedParams(Long feedId, List<Long> categoryIds) {

        if (categoryIds == null) {
            return withTextAdGroupFeedParams(feedId);
        }
        ArrayOfLong categories = new ArrayOfLong();
        categories.setItems(categoryIds);

        TextAdGroupFeedParamsAdd textAdGroupFeedParamsAdd = new TextAdGroupFeedParamsAdd();
        textAdGroupFeedParamsAdd.setFeedId(feedId);
        textAdGroupFeedParamsAdd.setFeedCategoryIds(categories);

        this.put(TEXT_AD_GROUP_WITH_FEED_PARAMS, textAdGroupFeedParamsAdd);
        return this;
    }

    public AdGroupAddItemMap withTextAdGroupFeedParams(Long feedId) {

        TextAdGroupFeedParamsAdd textAdGroupFeedParamsAdd = new TextAdGroupFeedParamsAdd();
        textAdGroupFeedParamsAdd.setFeedId(feedId);
        textAdGroupFeedParamsAdd.setFeedCategoryIds(null);

        this.put(TEXT_AD_GROUP_WITH_FEED_PARAMS, textAdGroupFeedParamsAdd);
        return this;
    }

    public AdGroupAddItemMap withNegativeKeywords(String[] items) {
        return this.withNegativeKeywords(new ArrayOfStringMap().withItems(items));
    }

    public AdGroupAddItemMap withNegativeKeywords(String firstItem, String... restOfItems) {
        String[] items = ArrayUtils.addAll(new String[]{firstItem}, restOfItems);
        return this.withNegativeKeywords(new ArrayOfStringMap().withItems(items));
    }

    public AdGroupAddItemMap withNegativeKeywords(List<String> items) {
        return this.withNegativeKeywords(new ArrayOfStringMap().withItems(items));
    }

    public AdGroupAddItemMap defaultAdGroupAddItem(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        this.put(NAME, DEFAULT_NAME);
        this.put(REGION_IDS, Collections.singletonList(DEFAULT_REGION_ID));
        return this;
    }
}
