package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.Arrays;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.adgroups.ObjectFactory;
import com.yandex.direct.api.v5.adgroups.TextAdGroupFeedParamsAdd;
import com.yandex.direct.api.v5.general.ArrayOfLong;
import com.yandex.direct.api.v5.general.ArrayOfString;
import org.apache.commons.lang3.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfLongMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class AdGroupBaseMap<T> extends ModelBeanMap<AdGroupBaseMap> {

    public static final String REGION_IDS = "regionIds";
    public static final String NEGATIVE_KEYWORDS = "negativeKeywords";
    public static final String TRACKING_PARAMS = "trackingParams";
    public static final String NEGATIVE_KEYWORD_SHARED_SET_IDS = "negativeKeywordSharedSetIds";
    public static final String TEXT_AD_GROUP_WITH_FEED_PARAMS = "textAdGroupFeedParams";


    public AdGroupBaseMap() {
        super();
    }

    public T withRegionIds(Long... regionIds) {
        this.put(REGION_IDS, Arrays.asList(regionIds));
        return (T) this;
    }

    public T withNegativeKeywords(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString negativeKeywords =
                (ArrayOfString) ((arrayOfStringMap == null) ? null : arrayOfStringMap.getBean());
        JAXBElement<ArrayOfString> jaxbElement =
                new ObjectFactory().createAdGroupBaseNegativeKeywords(negativeKeywords);
        this.put(NEGATIVE_KEYWORDS, jaxbElement);
        return (T) this;
    }

    public T withNegativeKeywords(String[] items) {
        return this.withNegativeKeywords(new ArrayOfStringMap().withItems(items));
    }

    public T withNegativeKeywords(String firstItem, String... restOfItems) {
        String[] items = ArrayUtils.addAll(new String[]{firstItem}, restOfItems);
        return this.withNegativeKeywords(new ArrayOfStringMap().withItems(items));
    }

    public T withTrackingParams(String trackingParams) {
        this.put(TRACKING_PARAMS, trackingParams);
        return (T) this;
    }

    public T withNegativeKeywordSharedSetIds(ArrayOfLongMap arrayOfLongMap) {
        ArrayOfLong negativeKeywordSharedSetIds =
                (ArrayOfLong) ((arrayOfLongMap == null) ? null : arrayOfLongMap.getBean());
        JAXBElement<ArrayOfLong> jaxbElement =
                new ObjectFactory().createAdGroupBaseNegativeKeywordSharedSetIds(negativeKeywordSharedSetIds);
        this.put(NEGATIVE_KEYWORD_SHARED_SET_IDS, jaxbElement);
        return (T) this;
    }

    public T withDefaultGroupWithFeedParams(Long feedId, ArrayOfLong categoryIds) {
        TextAdGroupFeedParamsAdd textAdGroupFeedParamsAdd = new ObjectFactory().createTextAdGroupFeedParamsAdd();
        textAdGroupFeedParamsAdd.setFeedId(feedId);
        textAdGroupFeedParamsAdd.setFeedCategoryIds(categoryIds);

        this.put(TEXT_AD_GROUP_WITH_FEED_PARAMS, textAdGroupFeedParamsAdd);
        return (T) this;
    }
}
