package ru.yandex.autotests.directapi.model.api5.adgroups;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.AdGroupSubtypeEnum;
import com.yandex.direct.api.v5.adgroups.ObjectFactory;
import com.yandex.direct.api.v5.general.AdGroupTypesEnum;
import com.yandex.direct.api.v5.general.ArrayOfLong;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import com.yandex.direct.api.v5.general.StatusEnum;

import ru.yandex.autotests.directapi.model.api5.general.ArrayOfLongMap;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class AdGroupGetItemMap extends AdGroupBaseMap<AdGroupGetItemMap> {

    public static final String ID = "id";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String STATUS = "status";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String SUBTYPE = "subtype";
    public static final String SERVING_STATUS = "servingStatus";
    public static final String RESTRICTED_REGION_IDS = "restrictedRegionIds";
    public static final String MOBILE_APP_AD_GROUP = "mobileAppAdGroup";
    public static final String DYNAMIC_TEXT_AD_GROUP = "dynamicTextAdGroup";
    public static final String DYNAMIC_TEXT_FEED_AD_GROUP = "dynamicTextFeedAdGroup";
    public static final String TEXT_AD_GROUP_WITH_FEED_PARAMS = "textAdGroupFeedParams";

    public AdGroupGetItemMap() {
        super();
        setBean(new AdGroupGetItem());
    }

    public AdGroupGetItemMap(AdGroupGetItem adGroupGetItem) {
        super();
        setBean(adGroupGetItem);
    }

    public AdGroupGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdGroupGetItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public AdGroupGetItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public AdGroupGetItemMap withStatus(StatusEnum status) {
        this.put(STATUS, status);
        return this;
    }

    public AdGroupGetItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public AdGroupGetItemMap withType(AdGroupTypesEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public AdGroupGetItemMap withSubtype(AdGroupSubtypeEnum subtype) {
        this.put(SUBTYPE, subtype);
        return this;
    }

    public AdGroupGetItemMap withServingStatus(ServingStatusEnum servingStatus) {
        this.put(SERVING_STATUS, servingStatus);
        return this;
    }

    public AdGroupGetItemMap withMobileAppAdGroup(MobileAppAdGroupGetMap mobileAppAdGroupGet) {
        this.put(MOBILE_APP_AD_GROUP, (mobileAppAdGroupGet == null) ? null : mobileAppAdGroupGet.getBean());
        return this;
    }

    public AdGroupGetItemMap withDynamicTextAdGroup(DynamicTextAdGroupGetMap dynamicTextAdGroupGet) {
        this.put(DYNAMIC_TEXT_AD_GROUP, (dynamicTextAdGroupGet == null) ? null : dynamicTextAdGroupGet.getBean());
        return this;
    }

    public AdGroupGetItemMap withDynamicTextFeedAdGroup(DynamicTextFeedAdGroupGetMap dynamicTextFeedAdGroupGet) {
        this.put(DYNAMIC_TEXT_FEED_AD_GROUP,
                (dynamicTextFeedAdGroupGet == null) ? null : dynamicTextFeedAdGroupGet.getBean());
        return this;
    }

    public AdGroupGetItemMap withRestrictedRegionIds(ArrayOfLongMap arrayOfLongMap) {
        ArrayOfLong restrictedRegions =
                (ArrayOfLong) ((arrayOfLongMap == null) ? null : arrayOfLongMap.getBean());
        JAXBElement<ArrayOfLong> jaxbElement =
                new ObjectFactory().createAdGroupGetItemRestrictedRegionIds(restrictedRegions);
        this.put(RESTRICTED_REGION_IDS, jaxbElement);
        return this;
    }

    public AdGroupGetItemMap withRestrictedRegionIds(Long... items) {
        ArrayOfLongMap arrayOfLongMap = (items == null) ? null : new ArrayOfLongMap().withItems(items);
        return this.withRestrictedRegionIds(arrayOfLongMap);
    }

    public AdGroupGetItemMap withTextAdGroupFeedParams() {
        this.put(TEXT_AD_GROUP_WITH_FEED_PARAMS, new ObjectFactory().createTextAdGroupFeedParamsGet());
        return this;
    }
}
