package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.List;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.adgroups.AdGroupUpdateItem;
import com.yandex.direct.api.v5.adgroups.ObjectFactory;
import com.yandex.direct.api.v5.adgroups.TextAdGroupFeedParamsUpdate;
import com.yandex.direct.api.v5.general.ArrayOfLong;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class AdGroupUpdateItemMap extends AdGroupBaseMap<AdGroupUpdateItemMap> {

    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String TRACKING_PARAMS = "trackingParams";
    public static final String MOBILE_APP_AD_GROUP = "mobileAppAdGroup";
    public static final String DYNAMIC_TEXT_AD_GROUP = "dynamicTextAdGroup";
    public static final String TEXT_AD_GROUP_WITH_FEED_PARAMS = "textAdGroupFeedParams";
    public static final int GROUPS_MAX_LENGTH = 1000;

    public AdGroupUpdateItemMap() {
        super();
        setBean(new AdGroupUpdateItem());
    }

    public AdGroupUpdateItemMap(AdGroupUpdateItem adGroupUpdateItem) {
        super();
        setBean(adGroupUpdateItem);
    }

    public AdGroupUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdGroupUpdateItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public AdGroupUpdateItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public AdGroupUpdateItemMap withTrackingParams(String params) {
        this.put(TRACKING_PARAMS, params);
        return this;
    }

    public AdGroupUpdateItemMap withMobileAppAdGroup(MobileAppAdGroupUpdateMap mobileAppAdGroupUpdate) {
        this.put(MOBILE_APP_AD_GROUP, (mobileAppAdGroupUpdate == null) ? null : mobileAppAdGroupUpdate.getBean());
        return this;
    }

    public AdGroupUpdateItemMap withDynamicTextAdGroup(DynamicTextAdGroupMap dynamicTextAdGroupAdd) {
        this.put(DYNAMIC_TEXT_AD_GROUP, (dynamicTextAdGroupAdd == null) ? null : dynamicTextAdGroupAdd.getBean());
        return this;
    }

    public AdGroupUpdateItemMap withTextAdGroupFeedParams(Long feedId, List<Long> categoryIds) {
        if (categoryIds == null) {
            return withTextAdGroupFeedParams(feedId);
        }
        TextAdGroupFeedParamsUpdate textAdGroupFeedParamsUpdate = new TextAdGroupFeedParamsUpdate();

        ArrayOfLong categories = new ArrayOfLong();
        categories.setItems(categoryIds);

        JAXBElement<ArrayOfLong> jaxbElement =
                new ObjectFactory().createTextAdGroupFeedParamsUpdateFeedCategoryIds(categories);

        textAdGroupFeedParamsUpdate.setFeedId(feedId);
        textAdGroupFeedParamsUpdate.setFeedCategoryIds(jaxbElement);

        this.put(TEXT_AD_GROUP_WITH_FEED_PARAMS, textAdGroupFeedParamsUpdate);
        return this;
    }

    public AdGroupUpdateItemMap withTextAdGroupFeedParams(Long feedId) {
        TextAdGroupFeedParamsUpdate textAdGroupFeedParamsUpdate = new TextAdGroupFeedParamsUpdate();

        JAXBElement<ArrayOfLong> jaxbElement =
                new ObjectFactory().createTextAdGroupFeedParamsUpdateFeedCategoryIds(null);

        textAdGroupFeedParamsUpdate.setFeedId(feedId);
        textAdGroupFeedParamsUpdate.setFeedCategoryIds(jaxbElement);

        this.put(TEXT_AD_GROUP_WITH_FEED_PARAMS, textAdGroupFeedParamsUpdate);
        return this;
    }

}
