package ru.yandex.autotests.directapi.model.api5.adgroups;

import com.yandex.direct.api.v5.adgroups.AdGroupAppIconStatusSelectionEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupStatusSelectionEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupsSelectionCriteria;
import com.yandex.direct.api.v5.general.AdGroupTypesEnum;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import java.util.Arrays;

/**
 * Author pavryabov
 * Date 24.06.14
 */
public class AdGroupsSelectionCriteriaMap extends ModelBeanMap<AdGroupsSelectionCriteriaMap> {

    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String IDS = "ids";
    public static final String TYPES = "types";
    public static final String STATUSES = "statuses";
    public static final String APP_ICON_STATUSES = "appIconStatuses";
    public static final String TAG_IDS = "tagIds";
    public static final String TAGS = "tags";
    public static final String SERVING_STATUSES = "servingStatuses";

    public static final int IDS_MAX_LENGTH = 10000;
    public static final int CAMPAIGN_IDS_MAX_LENGTH = 10;


    public AdGroupsSelectionCriteriaMap() {
        super();
        setBean(new AdGroupsSelectionCriteria());
    }

    public AdGroupsSelectionCriteriaMap(AdGroupsSelectionCriteria adGroupsSelectionCriteria) {
        super();
        setBean(adGroupsSelectionCriteria);
    }

    public AdGroupsSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdGroupsSelectionCriteriaMap withCampaignIds(Long... campaignIds) {
        this.put(CAMPAIGN_IDS, Arrays.asList(campaignIds));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withIds(Long... ids) {
        this.put(IDS, Arrays.asList(ids));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withStatuses(AdGroupStatusSelectionEnum... statuses) {
        this.put(STATUSES, Arrays.asList(statuses));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withStatuses(String... statuses) {
        this.put(STATUSES, Arrays.asList(statuses));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withTagIds(Long... tagIds) {
        this.put(TAG_IDS, Arrays.asList(tagIds));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withTags(String... tags) {
        this.put(TAGS, Arrays.asList(tags));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withTypes(AdGroupTypesEnum... types) {
        this.put(TYPES, Arrays.asList(types));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withAppIconStatuses(AdGroupAppIconStatusSelectionEnum... statuses) {
        this.put(APP_ICON_STATUSES, Arrays.asList(statuses));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withServingStatuses(ServingStatusEnum... servingStatuses) {
        this.put(SERVING_STATUSES, Arrays.asList(servingStatuses));
        return this;
    }

}
