package ru.yandex.autotests.directapi.model.api5.adgroups;

import com.yandex.direct.api.v5.adgroups.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final String AD_GROUPS = "adGroups";

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withAdGroups(AdGroupAddItemMap... adGroups) {
        this.put(AD_GROUPS, (adGroups == null) ? null : convert(adGroups, new BeanMapToBeanConverter()));
        return this;
    }
}
