package ru.yandex.autotests.directapi.model.api5.adgroups;

import com.yandex.direct.api.v5.adgroups.SourceProcessingStatusEnum;
import com.yandex.direct.api.v5.adgroups.SourceTypeGetEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Author gerdler
 */
public class DynamicSourceGetMap<T> extends ModelBeanMap<DynamicSourceGetMap> {
    public static final String SOURCE = "source";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String SOURCE_PROCESSING_STATUS = "sourceProcessingStatus";

    public DynamicSourceGetMap() {
        super();
    }

    public T withSource(String source) {
        this.put(SOURCE, source);
        return (T) this;
    }

    public T withSourceType(SourceTypeGetEnum sourceType) {
        this.put(SOURCE_TYPE, sourceType);
        return (T) this;
    }

    public T withSourceProcessingStatus(
            SourceProcessingStatusEnum sourceProcessingStatus)
    {
        this.put(SOURCE_PROCESSING_STATUS, sourceProcessingStatus);
        return (T) this;
    }
}


