package ru.yandex.autotests.directapi.model.api5.adgroups;

import com.yandex.direct.api.v5.adgroups.DynamicTextAdGroupGet;
import com.yandex.direct.api.v5.adgroups.SourceProcessingStatusEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Author buhter
 */
public class DynamicTextAdGroupGetMap extends ModelBeanMap<DynamicTextAdGroupGetMap> {
    public static final String DOMAIN_URL = "domainUrl";
    public static final String DOMAIN_URL_PROCESSING_STATUS = "domainUrlProcessingStatus";

    public DynamicTextAdGroupGetMap() {
        super();
        setBean(new DynamicTextAdGroupGet());
    }

    public DynamicTextAdGroupGetMap(DynamicTextAdGroupGet dynamicTextAdGroupGet) {
        super();
        setBean(dynamicTextAdGroupGet);
    }

    public DynamicTextAdGroupGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextAdGroupGetMap withDomainUrl(String domainUrl) {
        this.put(DOMAIN_URL, domainUrl);
        return this;
    }

    public DynamicTextAdGroupGetMap withDomainUrlProcessingStatus(
            SourceProcessingStatusEnum domainUrlProcessingStatus)
    {
        this.put(DOMAIN_URL_PROCESSING_STATUS, domainUrlProcessingStatus);
        return this;
    }
}


