package ru.yandex.autotests.directapi.model.api5.adgroups;

import com.yandex.direct.api.v5.adgroups.DynamicTextAdGroup;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Author buhter
 */
public class DynamicTextAdGroupMap extends ModelBeanMap<DynamicTextAdGroupMap> {
    public static final String DOMAIN_URL = "domainUrl";
    public static final String ANOTHER_DOMAIN_URL = "another.yandex.com";
    public static final String DEFAULT_DOMAIN_URL = "test.yandex.ru";

    public DynamicTextAdGroupMap() {
        super();
        setBean(new DynamicTextAdGroup());
    }

    public DynamicTextAdGroupMap(DynamicTextAdGroup dynamicTextAdGroup) {
        super();
        setBean(dynamicTextAdGroup);
    }

    public DynamicTextAdGroupMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextAdGroupMap withDomainUrl(String domainUrl) {
        this.put(DOMAIN_URL, domainUrl);
        return this;
    }

    public DynamicTextAdGroupMap defaultGroup() {
        this.put(DOMAIN_URL, DEFAULT_DOMAIN_URL);
        return this;
    }
}
