package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.DynamicTextAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.DynamicTextFeedAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetRequest;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.TextAdGroupFeedParamsFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

/**
 * Author pavryabov
 * Date 24.06.14
 */
public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";
    public static final String MOBILE_APP_AD_GROUP_FIELD_NAMES = "mobileAppAdGroupFieldNames";
    public static final String DYNAMIC_TEXT_AD_GROUP_FIELD_NAMES = "dynamicTextAdGroupFieldNames";
    public static final String DYNAMIC_TEXT_FEED_AD_GROUP_FIELD_NAMES = "dynamicTextFeedAdGroupFieldNames";
    public static final String TEXT_AD_GROUP_FEED_PARAMS_FIELD_NAMES = "textAdGroupFeedParamsFieldNames";

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(AdGroupsSelectionCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(AdGroupFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withFieldNames(String... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withMobileAppAdGroupFieldNames(MobileAppAdGroupFieldEnum... fieldNames) {
        this.put(MOBILE_APP_AD_GROUP_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withDynamicTextAdGroupFieldNames(DynamicTextAdGroupFieldEnum... fieldNames) {
        this.put(DYNAMIC_TEXT_AD_GROUP_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withDynamicTextFeedAdGroupFieldNames(DynamicTextFeedAdGroupFieldEnum... fieldNames) {
        this.put(DYNAMIC_TEXT_FEED_AD_GROUP_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withTextAdGroupFeedParamsFieldNames(TextAdGroupFeedParamsFieldEnum... fieldNames) {
        this.put(TEXT_AD_GROUP_FEED_PARAMS_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }
}
