package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupAdd;
import com.yandex.direct.api.v5.adgroups.TargetCarrierEnum;
import com.yandex.direct.api.v5.adgroups.TargetDeviceTypeEnum;
import org.apache.commons.lang3.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.OSVersions;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class MobileAppAdGroupAddMap extends ModelBeanMap<MobileAppAdGroupAddMap> {

    public static final String STORE_URL = "storeUrl";
    public static final String TARGET_DEVICE_TYPE = "targetDeviceType";
    public static final String TARGET_CARRIER = "targetCarrier";
    public static final String TARGET_OPERATING_SYSTEM_VERSION = "targetOperatingSystemVersion";

    public static final String ANDROID_STORE_URL =
            "http://play.google.com/store/apps/details?id=ru.yandex.searchplugin";
    public static final String DEFAULT_STORE_URL = ANDROID_STORE_URL;
    public static final String IOS_STORE_URL = "https://itunes.apple.com/ru/app/andeks.market/id425354015?mt=8";

    public static final String DEFAULT_TARGET_OPERATING_SYSTEM_VERSION = OSVersions.IOS_VERSIONS[9];
    public static final TargetDeviceTypeEnum[] DEFAULT_TARGET_DEVICE_TYPE
            = new TargetDeviceTypeEnum[]{TargetDeviceTypeEnum.DEVICE_TYPE_MOBILE
            , TargetDeviceTypeEnum.DEVICE_TYPE_TABLET};
    public static final TargetCarrierEnum DEFAULT_TARGET_CARRIER = TargetCarrierEnum.WI_FI_AND_CELLULAR;

    public MobileAppAdGroupAddMap() {
        super();
        setBean(new MobileAppAdGroupAdd());
    }

    public MobileAppAdGroupAddMap(MobileAppAdGroupAdd mobileAppAdGroupAdd) {
        super();
        setBean(mobileAppAdGroupAdd);
    }

    public MobileAppAdGroupAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppAdGroupAddMap withStoreUrl(String storeUrl) {
        this.put(STORE_URL, storeUrl);
        return this;
    }

    public MobileAppAdGroupAddMap withTargetDeviceTypes(TargetDeviceTypeEnum[] targetDeviceTypes) {
        this.put(TARGET_DEVICE_TYPE, Arrays.asList(targetDeviceTypes));
        return this;
    }

    public MobileAppAdGroupAddMap withTargetDeviceTypes(TargetDeviceTypeEnum firstTargetDeviceType,
            TargetDeviceTypeEnum... restOfTargetDeviceTypes)
    {
        TargetDeviceTypeEnum[] targetDeviceTypes =
                ArrayUtils.addAll(new TargetDeviceTypeEnum[]{ firstTargetDeviceType }, restOfTargetDeviceTypes);
        this.put(TARGET_DEVICE_TYPE, Arrays.asList(targetDeviceTypes));
        return this;
    }

    public MobileAppAdGroupAddMap withTargetCarrier(TargetCarrierEnum targetCarrier) {
        this.put(TARGET_CARRIER, targetCarrier);
        return this;
    }

    public MobileAppAdGroupAddMap withTargetOperatingSystemVersion(String targetOperatingSystemVersion) {
        this.put(TARGET_OPERATING_SYSTEM_VERSION, targetOperatingSystemVersion);
        return this;
    }

    public MobileAppAdGroupAddMap defaultGroup() {
        this.put(STORE_URL, DEFAULT_STORE_URL);
        this.put(TARGET_DEVICE_TYPE, Arrays.asList(DEFAULT_TARGET_DEVICE_TYPE));
        this.put(TARGET_CARRIER, DEFAULT_TARGET_CARRIER);
        this.put(TARGET_OPERATING_SYSTEM_VERSION, DEFAULT_TARGET_OPERATING_SYSTEM_VERSION);
        return this;
    }
}
