package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.Arrays;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.adgroups.AppAvailabilityStatusEnum;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupGet;
import com.yandex.direct.api.v5.adgroups.ObjectFactory;
import com.yandex.direct.api.v5.adgroups.TargetCarrierEnum;
import com.yandex.direct.api.v5.adgroups.TargetDeviceTypeEnum;
import com.yandex.direct.api.v5.general.ExtensionModeration;
import com.yandex.direct.api.v5.general.MobileOperatingSystemTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class MobileAppAdGroupGetMap extends ModelBeanMap<MobileAppAdGroupGetMap> {

    public static final String STORE_URL = "storeUrl";
    public static final String TARGET_DEVICE_TYPE = "targetDeviceType";
    public static final String TARGET_CARRIER = "targetCarrier";
    public static final String TARGET_OPERATING_SYSTEM_VERSION = "targetOperatingSystemVersion";
    public static final String APP_ICON_MODERATION = "appIconModeration";
    public static final String APP_OPERATING_SYSTEM_TYPE = "appOperatingSystemType";
    public static final String APP_AVAILABILITY_STATUS = "appAvailabilityStatus";

    public MobileAppAdGroupGetMap() {
        super();
        setBean(new MobileAppAdGroupGet());
    }

    public MobileAppAdGroupGetMap(MobileAppAdGroupGet mobileAppAdGroupGet) {
        super();
        setBean(mobileAppAdGroupGet);
    }

    public MobileAppAdGroupGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppAdGroupGetMap withStoreUrl(String storeUrl) {
        this.put(STORE_URL, storeUrl);
        return this;
    }

    public MobileAppAdGroupGetMap withTargetDeviceTypes(TargetDeviceTypeEnum... targetDeviceTypes) {
        this.put(TARGET_DEVICE_TYPE, Arrays.asList(targetDeviceTypes));
        return this;
    }

    public MobileAppAdGroupGetMap withTargetCarrier(TargetCarrierEnum targetCarrier) {
        this.put(TARGET_CARRIER, targetCarrier);
        return this;
    }

    public MobileAppAdGroupGetMap withTargetOperatingSystemVersion(String targetOperatingSystemVersion) {
        this.put(TARGET_OPERATING_SYSTEM_VERSION, targetOperatingSystemVersion);
        return this;
    }

    public MobileAppAdGroupGetMap withAppIconModeration(ExtensionModerationMap appIconModeration) {
        JAXBElement<ExtensionModeration> jaxbElement =
                new ObjectFactory().createMobileAppAdGroupGetAppIconModeration(
                        (appIconModeration == null) ? null : (ExtensionModeration) appIconModeration.getBean());
        this.put(APP_ICON_MODERATION, jaxbElement);
        return this;
    }

    public MobileAppAdGroupGetMap withAppOperatingSystemType(MobileOperatingSystemTypeEnum operatingSystemType) {
        this.put(APP_OPERATING_SYSTEM_TYPE, operatingSystemType);
        return this;
    }

    public MobileAppAdGroupGetMap withAppAvailabilityStatus(AppAvailabilityStatusEnum appAvailabilityStatus) {
        this.put(APP_AVAILABILITY_STATUS, appAvailabilityStatus);
        return this;
    }
}


