package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupUpdate;
import com.yandex.direct.api.v5.adgroups.TargetCarrierEnum;
import com.yandex.direct.api.v5.adgroups.TargetDeviceTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class MobileAppAdGroupUpdateMap extends ModelBeanMap<MobileAppAdGroupUpdateMap> {

    public static final String TARGET_DEVICE_TYPE = "targetDeviceType";
    public static final String TARGET_CARRIER = "targetCarrier";
    public static final String TARGET_OPERATING_SYSTEM_VERSION = "targetOperatingSystemVersion";

    public MobileAppAdGroupUpdateMap() {
        super();
        setBean(new MobileAppAdGroupUpdate());
    }

    public MobileAppAdGroupUpdateMap(MobileAppAdGroupUpdate mobileAppAdGroupUpdate) {
        super();
        setBean(mobileAppAdGroupUpdate);
    }

    public MobileAppAdGroupUpdateMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppAdGroupUpdateMap withTargetDeviceTypes(TargetDeviceTypeEnum... targetDeviceTypes) {
        this.put(TARGET_DEVICE_TYPE, Arrays.asList(targetDeviceTypes));
        return this;
    }

    public MobileAppAdGroupUpdateMap withTargetCarrier(TargetCarrierEnum targetCarrier) {
        this.put(TARGET_CARRIER, targetCarrier);
        return this;
    }

    public MobileAppAdGroupUpdateMap withTargetOperatingSystemVersion(String targetOperatingSystemVersion) {
        this.put(TARGET_OPERATING_SYSTEM_VERSION, targetOperatingSystemVersion);
        return this;
    }
}
