package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.List;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.adgroups.ObjectFactory;
import com.yandex.direct.api.v5.adgroups.TextAdGroupFeedParamsGet;
import com.yandex.direct.api.v5.general.ArrayOfLong;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class TextAdGroupFeedParamsGetMap extends ModelBeanMap<TextAdGroupFeedParamsGetMap> {

    public static final String FEED_ID = "feedId";
    public static final String FEED_CATEGORY_IDS = "feedCategoryIds";

    public TextAdGroupFeedParamsGetMap() {
        super();
        setBean(new TextAdGroupFeedParamsGet());
    }

    public TextAdGroupFeedParamsGetMap(TextAdGroupFeedParamsGet textAdGroupFeedParamsGet) {
        super();
        setBean(textAdGroupFeedParamsGet);
    }

    public TextAdGroupFeedParamsGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextAdGroupFeedParamsGetMap withFeedId(Long feedId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createTextAdGroupFeedParamsGetFeedId(feedId);
        this.put(FEED_ID, jaxbElement);
        return this;
    }

    public TextAdGroupFeedParamsGetMap withFeedCategoryIds(
            List<Long> feedCategoryIds) {
        ArrayOfLong feedCategories = new ArrayOfLong();
        feedCategories.setItems(feedCategoryIds);
        JAXBElement<ArrayOfLong> jaxbElement = new ObjectFactory()
                .createTextAdGroupFeedParamsGetFeedCategoryIds(feedCategories);
        this.put(FEED_CATEGORY_IDS, jaxbElement);
        return this;
    }
}
