package ru.yandex.autotests.directapi.model.api5.adgroups;

import com.yandex.direct.api.v5.adgroups.UpdateRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class UpdateRequestMap extends ModelBeanMap<UpdateRequestMap> {

    public static final String AD_GROUPS = "adGroups";

    public UpdateRequestMap() {
        super();
        setBean(new UpdateRequest());
    }

    public UpdateRequestMap(UpdateRequest updateRequest) {
        super();
        setBean(updateRequest);
    }

    public UpdateRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public UpdateRequestMap withAdGroups(AdGroupUpdateItemMap... adGroups) {
        this.put(AD_GROUPS, (adGroups == null) ? null : convert(adGroups, new BeanMapToBeanConverter()));
        return this;
    }
}
