package ru.yandex.autotests.directapi.model.api5.adimages;

import com.yandex.direct.api.v5.adimages.AdImageAddItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.utils.ImageBase64Utils;


/**
 * Created by ginger on 21.04.16.
 */
public class AdImageAddItemMap extends ModelBeanMap<AdImageAddItemMap> {

    public static final String IMAGE_DATA = "imageData";
    public static final String NAME = "name";

    public AdImageAddItemMap() {
        super();
        setBean(new AdImageAddItem());
    }

    public AdImageAddItemMap(AdImageAddItem adImageAddItem) {
        super();
        setBean(adImageAddItem);
    }

    public AdImageAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdImageAddItemMap withImageData(byte[] imageData) {
        this.put(IMAGE_DATA, imageData);
        return this;
    }

    public AdImageAddItemMap withImageData(String url) {
        this.put(IMAGE_DATA, ImageBase64Utils.getFileData(url));
        return this;
    }

    public AdImageAddItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }
}
