package ru.yandex.autotests.directapi.model.api5.adimages;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.adimages.AdImageGetItem;
import com.yandex.direct.api.v5.adimages.AdImageSubtypeEnum;
import com.yandex.direct.api.v5.adimages.AdImageTypeEnum;
import com.yandex.direct.api.v5.adimages.ObjectFactory;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 06.02.16.
 */
public class AdImageGetItemMap extends ModelBeanMap<AdImageGetItemMap> {

    public static final String AD_IMAGE_HASH = "adImageHash";
    public static final String NAME = "name";
    public static final String ASSOCIATED = "associated";
    public static final String TYPE = "type";
    public static final String ORIGIN_URL = "originalUrl";
    public static final String PREVIEW_URL = "previewUrl";
    public static final String SUBTYPE = "subtype";

    public AdImageGetItemMap() {
        super();
        setBean(new AdImageGetItem());
    }

    public AdImageGetItemMap(AdImageGetItem adImageGetItem) {
        super();
        setBean(adImageGetItem);
    }

    public AdImageGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdImageGetItemMap withAdImageHash(String adImageHash) {
        this.put(AD_IMAGE_HASH, adImageHash);
        return this;
    }

    public AdImageGetItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public AdImageGetItemMap withAssociated(YesNoEnum yesNoEnum) {
        this.put(ASSOCIATED, yesNoEnum);
        return this;
    }

    public AdImageGetItemMap withType(AdImageTypeEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public AdImageGetItemMap withOriginalUrl(String originalUrl) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createAdImageGetItemOriginalUrl(originalUrl);
        this.put(ORIGIN_URL, jaxbElement);
        return this;
    }

    public AdImageGetItemMap withPreviewUrl(String previewUrl) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createAdImageGetItemPreviewUrl(previewUrl);
        this.put(PREVIEW_URL, jaxbElement);
        return this;
    }

    public AdImageGetItemMap withSubtype(AdImageSubtypeEnum subtype) {
        this.put(SUBTYPE, subtype);
        return this;
    }
}
