package ru.yandex.autotests.directapi.model.api5.adimages;

import java.util.Arrays;

import com.yandex.direct.api.v5.adimages.AdImageSelectionCriteria;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 06.02.16.
 */
public class AdImageSelectionCriteriaMap extends ModelBeanMap<AdImageSelectionCriteriaMap> {

    public static final String AD_IMAGE_HASHES = "adImageHashes";
    public static final String ASSOCIATED = "associated";

    public AdImageSelectionCriteriaMap() {
        super();
        setBean(new AdImageSelectionCriteria());
    }

    public AdImageSelectionCriteriaMap(AdImageSelectionCriteria adImagesSelectionCriteria) {
        super();
        setBean(adImagesSelectionCriteria);
    }

    public AdImageSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdImageSelectionCriteriaMap withAdImageHashes(String... adImageHashes) {
        this.put(AD_IMAGE_HASHES, Arrays.asList(adImageHashes));
        return this;
    }

    public AdImageSelectionCriteriaMap withAssociated(YesNoEnum associated) {
        this.put(ASSOCIATED, associated);
        return this;
    }
}
