package ru.yandex.autotests.directapi.model.api5.adimages;

import com.yandex.direct.api.v5.adimages.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by ginger on 21.04.16.
 */
public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final String AD_IMAGES = "adImages";

    public static final int MAX_AMOUNT_OF_IMAGE_IN_ADD_REQUEST = 100;
    public static final int MAX_NAME_LENGTH = 255;

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withAdImages(AdImageAddItemMap... adImages) {
        this.put(AD_IMAGES, (adImages == null) ? null : convert(adImages, new BeanMapToBeanConverter()));
        return this;
    }
}
