package ru.yandex.autotests.directapi.model.api5.adimages;

import com.yandex.direct.api.v5.adimages.DeleteRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 21.04.16.
 */
public class DeleteRequestMap extends ModelBeanMap<DeleteRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public static final Integer MAX_AMOUNT_OF_IMAGE_HASH_IN_DELETE_REQUEST = 10000;

    public DeleteRequestMap() {
        super();
        setBean(new DeleteRequest());
    }

    public DeleteRequestMap(DeleteRequest deleteRequest) {
        super();
        setBean(deleteRequest);
    }

    public DeleteRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DeleteRequestMap withSelectionCriteria(AdImageHashesCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
